package {
	
	import away3d.core.base.Vertex;
	import away3d.core.math.Matrix3D;
	import away3d.lights.DirectionalLight3D;
	import away3d.materials.ColorMaterial;
	import away3d.materials.PhongBitmapMaterial;
	import away3d.materials.PhongColorMaterial;
	import away3d.materials.ShadingColorMaterial;
	import away3d.materials.WhiteShadingBitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	
	import fr.seraf.wow.core.WOWEngine;
	import fr.seraf.wow.core.data.WVector;
	import fr.seraf.wow.primitive.WSphere;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class ClothSimuDemo extends EventDispatcherThread implements IDemoThread {
		
		[Embed(source='../assets/saqoosha.jpg')]
		private static const saqooshaTexClass:Class;
		private static const saqooshaTex:BitmapData = Bitmap(new saqooshaTexClass()).bitmapData;

		private static const CLOTH_WIDTH:int = 80;
		private static const CLOTH_HEGHT:int = 60;

		private var _ctx:Context;
		private var _wow:WOWEngine;
		private var _cloth:Cloth;
		private var _edge:Array;
		private var _green:Plane;
		private var _tmp:Vertex = new Vertex();
		
		public function ClothSimuDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			this._wow = new WOWEngine(1/3);
			this._wow.collisionResponseMode = this._wow.SELECTIVE;
			this._wow.addMasslessForce(new WVector(0, -3, 0));

			var mat:WhiteShadingBitmapMaterial = new WhiteShadingBitmapMaterial(saqooshaTex);
//			var back:ColorMaterial = new ColorMaterial(0x333333);
//			var back:PhongColorMaterial = new PhongColorMaterial(0x333333);

			var dimmed:BitmapData = new BitmapData(saqooshaTex.width, saqooshaTex.height, false, 0x0);
			dimmed.draw(saqooshaTex, null, new ColorTransform(1, 1, 1, 0.5));
			var back:WhiteShadingBitmapMaterial = new WhiteShadingBitmapMaterial(dimmed);

			this._cloth = new Cloth({wow:this._wow, material:mat, width:CLOTH_WIDTH, height:CLOTH_HEGHT, segments:6, yUp:false, back:back, bothsides:true});
			this._ctx.arview.scene.addChild(this._cloth);
			
			this._edge = this._cloth.getEdgeVertices();
			for (var i:int = 0; i < this._edge.length; i++) {
				var v:Vertex = this._edge[i];
				var vi:Vertex = v.extra.init;
				vi.x = i / this._cloth.segmentsW * this._cloth.width - this._cloth.width / 2;
				vi.y = 0;
				vi.z = 40;
				WSphere(v.extra.physics).fixed = true;
			}
			
//			var green:ColorMaterial = new ColorMaterial(0x00ff00);
//			this._green = new Plane({material:green, width:85, height:85});
//			this._ctx.arview.marker.addChild(this._green);
//			
//			this._ctx.arview.filters = [
//				new ColorMatrixFilter([
//					1,  0, 0, 0, 0,
//					0,  1, 0, 0, 0,
//					0,  0, 1, 0, 0,
//					1, -1, 1, 1, 0
//				])
//			];
			
			event(this._ctx.renderThread, RenderThread.PRE_RENDER, this._onPreRender);
		}
		
		private function _onPreRender(e:Event):void {
			if (checkInterrupted()) {
				return;
			}
			for each (var v:Vertex in this._edge) {
				var p:WSphere = WSphere(v.extra.physics);
				var vi:Vertex = Vertex(v.extra.init);
				this.multiplyVertex(this._ctx.arview.marker.transform, vi, this._tmp);
				p.px = this._tmp.x;
				p.py = this._tmp.y;
				p.pz = this._tmp.z;
			}
			this._wow.step();
			this._cloth.update();
			this._cloth.updateNormal();
			event(this._ctx.renderThread, RenderThread.PRE_RENDER, this._onPreRender);
			interrupted(this._cleanup);
		}

		private function multiplyVertex(m:Matrix3D, vi:Vertex, vo:Vertex):Vertex {
			var vx:Number = vi.x;
			var vy:Number = vi.y;
			var vz:Number = vi.z;
			vo.x = vx * m.sxx + vy * m.sxy + vz * m.sxz + m.tx;
			vo.y = vx * m.syx + vy * m.syy + vz * m.syz + m.ty;
			vo.z = vx * m.szx + vy * m.szy + vz * m.szz + m.tz;
			return vo;
		}
		
		public function close():void {
			this.interrupt();
		}

		private function _cleanup():void {
			this._ctx.arview.scene.removeChild(this._cloth);
			this._cloth = null;
			this._wow = null;
			this._edge = null;
		}
	}
}


import away3d.core.base.Face;
import away3d.core.base.Vertex;
import away3d.primitives.Plane;

import fr.seraf.wow.constraint.WSpringConstraint;
import fr.seraf.wow.core.WOWEngine;
import fr.seraf.wow.primitive.WSphere;

class Cloth extends Plane {
	
	public static var DEFAULT_PARTICLE_SIZE:Number = 1.0;
	public static var DEFAULT_SPRING_STIFFNESS:Number = 0.5;
	
	public function Cloth(init:Object = null) {
		super(init);
		
		var wow:WOWEngine = ini.getObject('wow', WOWEngine) as WOWEngine
		if (!wow) {
			throw new ArgumentError('');
		}
		
		var vs:Array = this.vertices;
		function createSpring(i1:int, i2:int):void {
			var spring:WSpringConstraint = new WSpringConstraint(WSphere(vs[i1].extra.physics), WSphere(vs[i2].extra.physics), DEFAULT_SPRING_STIFFNESS);
			spring.massAffected = false;
			wow.addConstraint(spring);
		}
		
		var n:int = vs.length;
		for (var i:int = 0; i < n; i++) {
			var v:Vertex = vs[i];
			var p:WSphere  = new WSphere(v.x, v.y, v.z, DEFAULT_PARTICLE_SIZE, false);
			wow.addParticle(p);
			v.extra = {init:v.clone(), physics:p};
			if (i > 0) {
				if (i < (this.segmentsH + 1) * 2) {
					if (i & 1) {
						createSpring(i, i - 1);
					}
					if (i > 1) {
						createSpring(i, i - 2);
					}
				} else {
					if (int(i / (this.segmentsH + 1)) == 2) {
						createSpring(i, (i % (this.segmentsH + 1)) * 2 + 1);
					} else {
						createSpring(i, i - (this.segmentsH + 1));
					}
					if (i % (this.segmentsH + 1)) {
						createSpring(i, i - 1);
					}
				}
			}
		}
	}
	
	public function getEdgeVertices(whichSide:int = 0):Array {
		var ev:Array = [];
		var vs:Array = this.vertices;
		switch (whichSide) {
			case 0:
				ev.push(vs[this.segmentsH * 2]);
				ev.push(vs[this.segmentsH * 2 + 1]);
				for (var i:int = 2; i <= this.segmentsW; i++) {
					ev.push(vs[(i + 1) * (this.segmentsH + 1) - 1]);
				}
				break;
		}
		return ev;
	}
	
	public function update():void {
		for each (var v:Vertex in this.vertices) {
			var p:WSphere = WSphere(v.extra.physics);
			v.x = p.px;
			v.y = p.py;
			v.z = p.pz;
		}
	}
	
	public function updateNormal():void {
		for each (var f:Face in this.faces) {
			f.normalDirty = true;
		}
	}
}